package easik.ui.tree.popup;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphLayoutCache;

import easik.Easik;
import easik.sketch.attribute.AttributeUI;
import easik.sketch.attribute.EntityAttribute;
import easik.sketch.datatype.DataType;
import easik.sketch.vertex.EntityNode;


/**
 * Add attribute popup menu action for the information tree.
 * 
 * @author Kevin Green 2006
 * @since 2006-06-14 Kevin Green
 * @version 2006-07-26 Kevin Green
 */
public class AddAttributeAction extends AbstractAction {	
	
	/**
	 *	Set up the add attribute menu option.
	 */
	public AddAttributeAction() {
		super("Add Attribute");
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Add an attribute to the currently selected entity.");		
	}
	
	/**
	 * Inserts an attribute to the currently selected entity
	 * (or parent entity if attribute is selected) in the tree
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
		
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		EntityNode curEntity;
		DefaultMutableTreeNode entityNode;
		
		//Check what is currently selected
		if(curSelected instanceof EntityNode){
			//Entity is selected so set it as current entity
			entityNode = (DefaultMutableTreeNode) curSelectedNode;
			curEntity = (EntityNode) curSelected;
		}
		else if(curSelected instanceof EntityAttribute){
			//An attribute is selected so get its parent entity
			entityNode = (DefaultMutableTreeNode) curSelectedNode.getParent();
			curEntity = (EntityNode) entityNode.getUserObject();
		}
		else{
			JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
					"You do not have an entity selected. \nPlease select an entity and try again.",
					"No Entity Selected", JOptionPane.ERROR_MESSAGE);
			return;//Jump out of function
		}
		
		//TODO: Verify that there is a data type defined that can be used
		
		AttributeUI myUI = new AttributeUI();
		if(myUI.getExit())
		{
			//Get values from dialog
			String newAttName = myUI.getAttName();
			DataType newAttType = myUI.getAttType();
			
			//Check if attribute name already exists for this entity
			if(!EntityAttribute.isAttNameUsed(curEntity, newAttName) && !EntityAttribute.isProtectedName(curEntity, newAttName)){
				//Create Entity Attribute
				EntityAttribute newAtt = new EntityAttribute(newAttName, newAttType);
				//Add attribute to entity
				curEntity.addAttribute(newAtt);
				//Create attribute node
				DefaultMutableTreeNode attNode = new DefaultMutableTreeNode(newAtt);
				//Add node to attribute
				newAtt.setNode(attNode);
				//Add attribute to tree
				entityNode.add(attNode);
				Easik.getInstance().getFrame().getInfoTreeUI().refreshTree(entityNode); //Refresh view of entity
				
				Object[] myCell = new Object[1];
				myCell[0] = Easik.getInstance().getFrame().getSketch().getAdapter().getVertexCell(curEntity);
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().hideCells(myCell, true);
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().showCells(myCell, true);
				Easik.getInstance().getFrame().getSketch().repaint();
				
				Easik.getInstance().getFrame().getSketch().setDirty(true);
			}
			else{
				//Pop up error dialog
				if(EntityAttribute.isAttNameUsed(curEntity, newAttName)){
					JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
							"There is already an attribute with that name. \nPlease try again.",
							"Attribute Already Exists", JOptionPane.ERROR_MESSAGE);
				}
				else{
					JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
							"The entered name is protected.\nPlease try again.",
							"Name Protected", JOptionPane.ERROR_MESSAGE);
				}
			}
		}
	}
}
